package com.elitescloud.cloudt.comm.service;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.comm.vo.ComCurrRateVO;
import com.elitescloud.cloudt.comm.vo.param.ComCurrRateQueryParamVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 汇率
 *
 * @author ssy
 * 2020/7/3
 */
@FeignClient(name = Application.NAME, path = ComCurrRateService.URI)
@Validated
public interface ComCurrRateService {
    String URI = Application.URI_PREFIX + "/currRate";

    /**
     * 货币汇率转换
     *
     * @param param
     * @return 汇率
     */
    @PostMapping(value = "/findRatio")
    Double findRatio(@RequestBody ComCurrRateQueryParamVO param);

    /**
     * 检索
     *
     * @param queryParam 分类查询、分页和排序对象
     * @return 分页结果集
     */
    @PostMapping(value = "/search")
    PagingVO<ComCurrRateVO> search(@RequestBody ComCurrRateQueryParamVO queryParam);

    /**
     * 根据关键字段，返回对应的
     *
     * @param idList ID集合
     * @return 对象
     */
    @PostMapping(value = "/findIdBatch")
    List<ComCurrRateVO> findIdBatch(@RequestBody List<Long> idList);
}
