package com.elitescloud.cloudt.comm.vo.param;

import lombok.Builder;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Set;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/6/9
 */
@Data
@Builder
public class ComTaxRateQueryParamDTO implements Serializable {
    private static final long serialVersionUID = 1137003885156599923L;

    /**
     * ID
     */
    private Long id;

    /**
     * ID集合
     */
    private Set<Long> ids;

    /**
     * 税率编号
     */
    private String taxRateNo;

    /**
     * 税率编号
     */
    private Set<String> taxRateNos;

    /**
     * 处于有效期的
     */
    private Boolean valid;

    /**
     * 生效日期起始时间
     */
    private LocalDateTime validFromStart;

    /**
     * 生效日期截止时间
     */
    private LocalDateTime validFromEnd;

    /**
     * 失效日期起始时间
     */
    private LocalDateTime validToStart;

    /**
     * 失效日期截止时间
     */
    private LocalDateTime validToEnd;

    /**
     * 税率索引
     */
    private String taxRateIndex;

    /**
     * 税率索引
     */
    private Set<String> taxRateIndexes;
}
