package com.elitescloud.cloudt.constant;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 下一编号类型.
 *
 * @author Kaiser（wang shao）
 * 2022/11/14
 */
public enum SysNumType {
    /**
     * 固定值
     */
    FS("固定值"),
    /**
     * 日期格式
     */
    DP("日期格式"),
    /**
     * 自增序号
     */
    NN("下一编号"),
    /**
     * 运行时变量
     */
    RV("运行时变量"),
    ;

    /**
     * 描述
     */
    private final String description;

    SysNumType(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    private static final Map<String, SysNumType> ALL = Arrays.stream(SysNumType.values())
            .collect(Collectors.toMap(SysNumType::name, t -> t, (t1, t2) -> t1));

    /**
     * 转换对象
     *
     * @param value
     * @return
     */
    public static SysNumType parse(String value) {
        return ALL.get(value);
    }
}
