package com.elitescloud.cloudt.support.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Chris
 * 2021-06-03
 */
@Data
@ApiModel("地址薄-银行信息DTO")
public class OrgBankAccRpcDTO implements Serializable {

    private static final long serialVersionUID = 3969102501710554257L;

    /**
     * 银行信息ID
     */
    @ApiModelProperty("银行信息ID")
    private Long id;

    /**
     * 地址薄地址号
     */
    @ApiModelProperty("地址薄地址号")
    private Long addrNo;

    /**
     * 地址薄名称
     */
    @ApiModelProperty("地址薄名称")
    private String addrName;

    /**
     * 地址薄类型:[UDC]ORG:ADDR_TYPE
     */
    @ApiModelProperty("地址薄类型:[UDC]ORG:ADDR_TYPE")
    private String addrType;

    /**
     * 账号类型:[UDC]ORG:ADDR_BANKACC_TYPE
     */
    @ApiModelProperty("账号类型:[UDC]ORG:ADDR_BANKACC_TYPE")
    private String accType;

    /**
     * 是否默认：1是，0否
     */
    @ApiModelProperty("是否默认：1是，0否")
    private Boolean defaultFlag;

    /**
     * 银行ID
     */
    @ApiModelProperty("银行ID")
    private Long bankId;

    /**
     * 银行编号
     */
    @ApiModelProperty("银行编号")
    private String bankCode;

    /**
     * 银行名称
     */
    @ApiModelProperty("银行名称")
    private String bankName;

    /**
     * 网点名称
     */
    @ApiModelProperty("网点名称")
    private String branchName;

    /**
     * 开户行账号
     */
    @ApiModelProperty("开户行账号")
    private String bankAcc;

    /**
     * 收付款方式
     */
    @ApiModelProperty(value = "收付款方式：[UDC]COM:PAY_METHOD")
    private String payCollectMethod;


    /**
     * 开户行账号名称
     */
    @ApiModelProperty(value = "开户行账号名称")
    private String bankAccountName;

    /**
     * 开户行账号组合
     */
    @ApiModelProperty(value = "开户行账号组合")
    private String bankAccountComp;


    /**
     * 开户人姓名
     */
    @ApiModelProperty("开户人姓名")
    private String holderName;

    /**
     * 第三方虚拟用户ID
     */
    @ApiModelProperty(value = "第三方虚拟用户ID")
    private String thirdpartyVirtualUserId;


    /**
     * 第三方虚拟帐户
     */
    @ApiModelProperty(value = "第三方虚拟帐户")
    private String thirdpartyVirtualAcc;

    /**
     * 币种
     */
    @ApiModelProperty("币种")
    private String currCode;

    /**
     * 币种名称
     */
    @ApiModelProperty("币种名称")
    private String currName;
}
