package com.elitescloud.cloudt.support.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author Chris
 * 2021-05-10
 */
@Data
@ApiModel("组织详情DTO")
public class OrgBuDetailsRpcDTO implements Serializable {

    private static final long serialVersionUID = 8662376053424613115L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "Id")
    private Long id;

    /**
     * 组织编号
     */
    @ApiModelProperty("组织编号")
    private String buCode;

    /**
     * 组织名称
     */
    @ApiModelProperty("组织名称")
    private String buName;

    /**
     * 组织简称
     */
    @ApiModelProperty("组织简称")
    private String buAbbr;

    /**
     * 所属公司名称
     */
    @ApiModelProperty("所属公司名称")
    private String ouName;

    /**
     * 组织类型 [UDC]ORG:BU_TYPE
     */
    @ApiModelProperty("组织类型 [UDC]ORG:BU_TYPE")
//    @SysCode(sys = "ORG", mod = "BU_TYPE")
    private String buType;
    private String buTypeName;

    /**
     * 组织状态 [UDC]ORG:BU_STATUS
     */
    @ApiModelProperty("组织状态 [UDC]ORG:BU_STATUS")
    @SysCode(sys = "ORG", mod = "BU_STATUS")
    private String buStatus;
    private String buStatusName;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    /**
     * 创建者
     */
    @ApiModelProperty("创建者")
    private String creator;

    /**
     * 排序号码
     */
    @ApiModelProperty("排序号码")
    private Integer sortNo;

    /**
     * 类别码
     */
    @ApiModelProperty("类别码")
    String cat;

    /**
     * 类别码2
     */
    @ApiModelProperty("类别码2")
    String cat2;

    /**
     * 类别码3
     */
    @ApiModelProperty("类别码3")
    String cat3;

    /**
     * 类别码4
     */
    @ApiModelProperty("类别码4")
    String cat4;

    /**
     * 类别码5
     */
    @ApiModelProperty("类别码5")
    String cat5;

    /**
     * 类别码6
     */
    @ApiModelProperty("类别码6")
    String cat6;

    /**
     * 类别码7
     */
    @ApiModelProperty("类别码7")
    String cat7;

    /**
     * 类别码8
     */
    @ApiModelProperty("类别码8")
    String cat8;

    /**
     * 类别码9
     */
    @ApiModelProperty("类别码9")
    String cat9;

    /**
     * 类别码10
     */
    @ApiModelProperty("类别码10")
    String cat10;

    /**
     * 类别码11
     */
    @ApiModelProperty("类别码11")
    String cat11;

    /**
     * 类别码12
     */
    @ApiModelProperty("类别码12")
    String cat12;

    /**
     * 类别码13
     */
    @ApiModelProperty("类别码13")
    String cat13;

    /**
     * 类别码14
     */
    @ApiModelProperty("类别码14")
    String cat14;

    /**
     * 类别码15
     */
    @ApiModelProperty("类别码15")
    String cat15;

    /**
     * 类别码16
     */
    @ApiModelProperty("类别码16")
    String cat16;

    /**
     * 类别码17
     */
    @ApiModelProperty("类别码17")
    String cat17;

    /**
     * 类别码18
     */
    @ApiModelProperty("类别码18")
    String cat18;

    /**
     * 类别码19
     */
    @ApiModelProperty("类别码19")
    String cat19;

    /**
     * 类别码20
     */
    @ApiModelProperty("类别码20")
    String cat20;

    /**
     * 类别码21
     */
    @ApiModelProperty("类别码21")
    String cat21;

    /**
     * 类别码22
     */
    @ApiModelProperty("类别码22")
    String cat22;

    /**
     * 类别码23
     */
    @ApiModelProperty("类别码23")
    String cat23;

    /**
     * 类别码24
     */
    @ApiModelProperty("类别码24")
    String cat24;

    /**
     * 类别码25
     */
    @ApiModelProperty("类别码25")
    String cat25;

    /**
     * 类别码26
     */
    @ApiModelProperty("类别码26")
    String cat26;

    /**
     * 类别码27
     */
    @ApiModelProperty("类别码27")
    String cat27;

    /**
     * 类别码28
     */
    @ApiModelProperty("类别码28")
    String cat28;

    /**
     * 类别码29
     */
    @ApiModelProperty("类别码29")
    String cat29;

    /**
     * 类别码30
     */
    @ApiModelProperty("类别码30")
    String cat30;

    /**
     * 地址簿参数
     */
    @ApiModelProperty("地址簿参数")
    private OrgAddrDetailsRpcDTO orgAddrDetailVO;
    /**
     * 成本中心编码
     */
    @ApiModelProperty("成本中心编码")
    private String costCentreCode;

    /**
     * 成本中心名称
     */
    @ApiModelProperty("成本中心名称")
    private String costCentreName;
}
