package com.elitescloud.cloudt.support.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author Chris
 * 2021-05-25
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("组织RPC DTO 查询条件")
public class OrgBuRpcDtoParam implements Serializable {

    /**
     * 组织ID列表
     */
    @ApiModelProperty("组织ID列表")
    private List<Long> buIds;

    /**
     * 组织编号列表
     */
    @ApiModelProperty("组织编号列表")
    private List<String> buCodes;

    /**
     * 组织所属公司id列表
     */
    @ApiModelProperty(value = "组织所属公司id列表")
    private List<Long> ouIds;

    /**
     * BU类型[UDC]ORG:BU_TYPE
     */
    @ApiModelProperty("BU类型[UDC]ORG:BU_TYPE")
    private String buType;


    @ApiModelProperty("是否需要全部数据,0/默认：全部数据（除草稿和已逻辑删除的数据）；1：正常状态数据；2：已停用状态数据")
    private Integer allDataFlag;

}
