package com.elitescloud.cloudt.support.service;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.support.dto.OrgOuUserRpcDTO;
import com.elitescloud.cloudt.support.dto.OrgUserEmpBuDTO;
import com.elitescloud.cloudt.support.param.OrgOuUserRpcDtoParam;
import com.elitescloud.cloudt.support.param.OrgUserIdBuParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author Chris
 * 2021-07-21
 */
@FeignClient(name = Application.NAME, path = OrgUserEmpBuRpcService.URI)
public interface OrgUserEmpBuRpcService {
    String URI = Application.URI_PREFIX + "/orgUserEmpBuRpcService";


    /**
     * 根据用户账号ID，获取绑定的员工组织信息
     *
     * @param userId 用户账号ID
     * @return 绑定员工组织信息
     */
    @GetMapping(value = "/findUserEmpBuInfoByUserId")
    ApiResult<OrgUserEmpBuDTO> findUserEmpBuInfoByUserId(@RequestParam("userId") Long userId);

    /**
     * 根据公司ID获取公司下所有员工绑定的用户账号ID
     *
     * @param param 查询参数
     * @return 用户账号ID
     */
    @GetMapping(value = "/findUserIdsByParam")
    ApiResult<List<Long>> findUserIdsByParam(@RequestParam("param") OrgUserIdBuParam param);

    /**
     * 查询公司绑定的用户
     *
     * @param param 查询条件
     * @return 用户信息
     */
    @GetMapping(value = "/findOuUserByParam")
    List<OrgOuUserRpcDTO> findOuUserByParam(@RequestParam("param") OrgOuUserRpcDtoParam param);
}
