package com.elitescloud.cloudt.support.vo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * 2021/3/10
 */
@Data
@ApiModel("BU组织返回参数")
public class OrgBuRemoteVO implements Serializable {

    private static final long serialVersionUID = -8967033247866327692L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "Id")
    private Long id;

    /**
     * 组织编号
     */
    @ApiModelProperty("组织编号")
    private String buCode;

    /**
     * 组织名称
     */
    @ApiModelProperty("组织名称")
    private String buName;

    /**
     * 组织简称
     */
    @ApiModelProperty("组织简称")
    private String buAbbr;

    /**
     * 所属公司id
     */
    @ApiModelProperty("所属公司id")
    private Long ouId;

    /**
     * 所属公司名称
     */
    @ApiModelProperty("所属公司名称")
    private String ouName;

    /**
     * 组织类型 [UDC]ORG:BU_TYPE
     */
    @ApiModelProperty("组织类型 [UDC]ORG:BU_TYPE")
    @SysCode(sys = "ORG", mod = "BU_TYPE")
    private String buType;
    private String buTypeName;

    /**
     * 组织状态 [UDC]ORG:BU_STATUS
     */
    @ApiModelProperty("组织状态 [UDC]ORG:BU_STATUS")
    @SysCode(sys = "ORG", mod = "BU_STATUS")
    private String buStatus;
    private String buStatusName;

}
