package com.elitescloud.cloudt.system.dto;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author : chen.niu
 * @description :
 * : 2023/1/31 14:45
 */
@Data
public class SysDprRoleApiDataRuleListQueryDTO implements Serializable  {

    private static final long serialVersionUID = 7141376063059273586L;
    @ApiModelProperty("id")
    @JsonSerialize(using = ToStringSerializer.class)
    Long id;
    @ApiModelProperty("租户tenantId")
    @JsonSerialize(using = ToStringSerializer.class)
    Long tenantId;

    @ApiModelProperty("行规则id")
    @Comment("行规则id")
    Long dprRuleId;

    @ApiModelProperty("自定义值")
    @Comment("自定义值")
    String roleRuleValue;

    @ApiModelProperty("自定义值填写类型")
    @Comment("自定义值填写类型（组件，自填）")
    String roleRuleValueType;

    @ApiModelProperty("规则排序")
    Double ruleOrder;


    @ApiModelProperty("规则关系（and-or）")
    String dprRuleRelation;
    String dprRuleRelationName;

    @ApiModelProperty("规则名称")
    String dprRuleName;

    @ApiModelProperty("规则描述")
    String dprRuleDeclare;

    @ApiModelProperty("规则字段")
    String dprRuleField;

    @ApiModelProperty("规则字段类型")
    String dprRuleFieldType;
    @ApiModelProperty("规则条件类型名称")
    String dprRuleFieldTypeName;


    @ApiModelProperty("规则字段描述")
    String dprRuleFieldDeclare;

    @ApiModelProperty("规则条件类型")
    String dprRuleCondition;
    @ApiModelProperty("规则条件类型名称")
    String dprRuleConditionName;

    @ApiModelProperty("规则值类型")
    String dprRuleValueType;
    @ApiModelProperty("规则值类型名称")
    String dprRuleValueTypeName;

    @ApiModelProperty("规则值")
    String dprRuleValue;

    @ApiModelProperty("规则值说明")
    String dprRuleValueDeclare;

    @ApiModelProperty("系统上下文内置类型枚举")
    String dprSysInternally;
    @ApiModelProperty("系统上下文内置类型名称")
    String dprSysInternallyName;


    @ApiModelProperty("角色自定义选择组件")
    String dprRoleCustomApp;
    @ApiModelProperty("角色自定义选择组件名称")
    String dprRoleCustomAppName;

    @ApiModelProperty("排序")
    Float dprRuleGroupRuleOrder;

    /***角色信息**/
    @ApiModelProperty("角色name")
    Long roleId;
    @ApiModelProperty("角色编码")
    private String roleCode;

    @ApiModelProperty("角色名称")
    private String roleName;

    @ApiModelProperty(value = "角色类型")
    private String roleType;

    @ApiModelProperty(value = "类型标识")
    private String roleTypeId;

    /**
     * 应用信息
     */
    @ApiModelProperty("应用appId")
    Long appId;
    @ApiModelProperty("应用编码")
    String appCode;

    @ApiModelProperty("应用名称")
    String appName;

    @ApiModelProperty("应用类型")
    String appType;

    @ApiModelProperty("描述")
    String appDescribe;

    /**
     * api接口信息
     ***/
    @ApiModelProperty("apiId")
    Long apiId;
    @ApiModelProperty("权限路径")
    String apiPermissionPath;

    @ApiModelProperty("权限名称")
    String apiPermissionName;

    @ApiModelProperty("权限编码")
    String apiPermissionCode;

    @ApiModelProperty("请求类型")
    String apiPermissionRequestType;

    @ApiModelProperty("描述")
    String apiPermissionDescribe;


    /**
     * 菜单信息
     **/

    @ApiModelProperty("菜单归属应用")
    String menusAppCode;

    @ApiModelProperty("菜单名称")
    String menusName;

    @ApiModelProperty("菜单类型 业务,系统")
    String menusType;

    @ApiModelProperty("节点类型 菜单,按钮")
    String menusNodeType;

    @ApiModelProperty("菜单编码")
    String menusCode;

    @ApiModelProperty("上级菜单编码")
    String menusParentCode;

    @ApiModelProperty("菜单路由")
    String menusRoute;

    @ApiModelProperty("描述")
    String menusDescribe;


    /**
     * 规则组信息
     */
    @ApiModelProperty("行规则组id")
    Long dprRuleGroupId;
    @ApiModelProperty("规则组名称")
    String dprRuleGroupName;

    @ApiModelProperty("规则组说明")
    String dprRuleGroupDeclare;

    @ApiModelProperty("是否启用")
    Boolean dprRuleGroupGroupEnable;

    @ApiModelProperty("公共，定制")
    String dprRuleGroupType;
    @ApiModelProperty("排序")
    Float dprRuleGroupOrder;
}
