package com.elitescloud.cloudt.system.provider.org;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.dto.req.EmployeeQueryDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 员工相关服务.
 *
 * @author Kaiser（wang shao）
 * 2022/12/20
 */
@FeignClient(name = Application.NAME, path = EmployeeRpcService.URI)
@Validated
public interface EmployeeRpcService {
    String URI = Application.URI_PREFIX + "/employee";

    /**
     * 根据员工ID获取员工信息
     *
     * @param id 员工ID
     * @return 员工信息
     */
    @GetMapping(value = "/getById")
    ApiResult<SysEmployeeBasicDTO> getById(@NotNull(message = "员工ID为空") @RequestParam(name = "id") Long id);

    /**
     * 根据员工ID获取员工信息
     *
     * @param code 员工编码
     * @return 员工信息
     */
    @GetMapping(value = "/getByCode")
    ApiResult<SysEmployeeBasicDTO> getByCode(@NotBlank(message = "员工编号为空") @RequestParam(name = "code") String code);

    /**
     * 根据账号获取员工信息
     *
     * @param username 登录账号
     * @return 员工信息
     */
    @GetMapping(value = "/getByUsername")
    ApiResult<SysEmployeeBasicDTO> getByUsername(@NotBlank(message = "用户账号为空") @RequestParam(name = "username") String username);

    /**
     * 根据用户ID获取所属员工
     *
     * @param userId 用户ID
     * @return 员工信息
     */
    @GetMapping(value = "/getByUserId")
    ApiResult<SysEmployeeBasicDTO> getByUserId(@NotNull(message = "用户ID为空") @RequestParam(name = "id")Long userId);

    /**
     * 查询员工列表
     *
     * @param queryDTO 查询参数
     * @return 员工列表
     */
    @PostMapping(value = "/queryList")
    ApiResult<List<SysEmployeeBasicDTO>> queryList(@RequestBody EmployeeQueryDTO queryDTO);
}
