package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiRowColumnRuleDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @author : chen
 *  角色应用api的数据权限远程调用接口
 * 2022-11-24 14:23
 */
@FeignClient(name = Application.NAME, path = RoleAppApiDataPermissionRpcService.URI)
@Validated
public interface RoleAppApiDataPermissionRpcService {
    String URI = Application.URI_PREFIX + "/role/app/api/data/permission";


//    /**
//     * 获取角色的数据权限信息
//     * @return 角色ID的数据集合
//     */
//    @PostMapping(value = "/getRoleAppApiDataPermission")
//    ApiResult<List<SysDprRoleApiRuleGroupDTO>> getRoleAppApiDataPermission();
//
//    /**
//     * 根据角色id 租户id 查询出数据权限
//     * @param @param null
//     * @return
//     */
//    @GetMapping(value = "/searchSysDprRoleApiRuleGroupDTO")
//    List<SysDprRoleApiRuleGroupDTO> searchSysDprRoleApiRuleGroupDTO(
//            @NotNull(message = "角色Id不能为空") @RequestParam("roelIdList") List<Long> roelIdList,
//             @NotNull(message = "租户id不能空")  @RequestParam("tenantId") Long tenantId);

    /**
     * 获取角色的数据权限信息
     * @return 角色ID的数据集合
     */
    @PostMapping(value = "/getRoleAppApiDataRulePermission")
    ApiResult<SysDprRoleApiRowColumnRuleDTO> getRoleAppApiDataRulePermission();


    /**
     * 返回账号的角色对应的全部应用-菜单-API-规则组信息和规则信息
     *
     * @param appCode 应用编码
     * @param udcCode UDC编码
     * @return UDC信息
     */

    /**
     * 统一身份管理登录后，采用token作为key 存储到redis中登录账号绑定的数据权限信息。
     *
     * @param appCode 应用编码
     * @param udcCode UDC编码
     * @return UDC信息
     */

    /**
     * 返回reids中token对应的数据权限数据。 token作为key获取。
     *
     * @param appCode 应用编码
     * @param udcCode UDC编码
     * @return UDC信息
     */



}
