package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.param.SysUserIdFlowRoleRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author Chris
 * 2021-08-04
 */
@FeignClient(name = Application.NAME, path = SysUserFlowRoleRpcService.URI)
@Validated
public interface SysUserFlowRoleRpcService {
    String URI = Application.URI_PREFIX + "/userFlowRole";

    /**
     * 根据流程角色查用户ID
     * @param param 查询参数
     * @return 用户ID列表
     */
    @PostMapping(value = "/findUserIdsByFlowRoles")
    List<Long> findUserIdsByFlowRoles(@RequestBody SysUserIdFlowRoleRpcParam param);
}
