package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.vo.SysRoleVO;
import com.elitescloud.cloudt.system.vo.SysUserRoleVO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 用户角色关联查询服务
 *
 * @author Michael Li
 * 2020-09-28
 */
@FeignClient(name = Application.NAME, path = SysUserRoleService.URI)
@Validated
public interface SysUserRoleService {
    String URI = Application.URI_PREFIX + "/userRole";

    @GetMapping(value = "/listUsersByRoleId")
    Set<SysUserVO> listUsersByRoleId(@RequestParam(value = "roleId") @NotNull(message = "角色ID为空") Long roleId);

    @PostMapping(value = "/listUsersByRoleIds")
    Map<Long, Set<SysUserVO>> listUsersByRoleIds(@RequestBody List<Long> roleIds);

    @GetMapping(value = "/listRolesByUserId")
    Set<SysRoleVO> listRolesByUserId(@RequestParam(value = "userId") @NotNull(message = "用户ID为空") Long userId);

    @PostMapping(value = "/listRolesByUserIds")
    Map<Long, Set<SysRoleVO>> listRolesByUserIds(@RequestBody List<Long> userIds);

    @PostMapping(value = "/saveAll")
    void saveAll(@RequestBody List<SysUserRoleVO> userRoles);

    @DeleteMapping(value = "/removeUsersByRoleIds")
    void removeUsersByRoleIds(@RequestBody List<Long> roleIds);

    @DeleteMapping(value = "/removeRolesByUserIds")
    void removeRolesByUserIds(@RequestBody List<Long> userIds);
}
