package com.elitescloud.cloudt.system.vo;

import com.elitescloud.cloudt.common.base.BaseViewModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.io.Serializable;

/**
 * <p>
 * 分类码明细表
 * </p>
 *
 * @author Michael Li
 * 2020/5/15
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
@ApiModel(value = "记录分类码的系统表", description = "分类码表")
public class SysUdcVO extends BaseViewModel implements Serializable {

    private static final long serialVersionUID = -6618541083363538072L;

    @ApiModelProperty(value = "领域码")
    @Size(min = 1, max = 20, message = "领域码长度必须在1~20之间")
    private String domainCode;

    @ApiModelProperty(value = "UDC码")
    @Size(min = 1, max = 32, message = "UDC码长度必须在1~32之间")
    private String udcCode;

    @ApiModelProperty(value = "UDC码名称")
    @Size(min = 1, max = 64, message = "UDC名称长度必须在1~64之间")
    private String udcName;

    @ApiModelProperty(value = "UDC值")
    @Size(min = 1, max = 32, message = "UDC名称长度必须在1~32之间")
    private String udcVal;

    @ApiModelProperty(value = "值描述")
    @NotBlank(message = "值描述不能为空")
    @Size(min = 1, max = 64, message = "值描述长度必须在1~64之间")
    private String valDesc;

    @ApiModelProperty(value = "排序号")
    private Integer valSortNo;

    @ApiModelProperty(value = "硬编码")
    private Boolean hdFlag;

    @ApiModelProperty(value = "是否开启数据权限")
    private Boolean dpFlag;

    @ApiModelProperty(value = "扩展字段1-特殊处理")
    private String es1;

    @ApiModelProperty(value = "扩展字段2")
    private String es2;

    @ApiModelProperty(value = "扩展字段3")
    private String es3;

    @ApiModelProperty(value = "扩展字段4")
    private String es4;

    @ApiModelProperty(value = "扩展字段5")
    private String es5;
}
