package com.elitescloud.cloudt.system.vo;

import com.elitescloud.cloudt.common.base.BaseViewModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * <pre>
 * 系统用户信息，脱敏
 * </pre>
 *
 * @author Michael Li
 * 2020/6/16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("系统用户信息，脱敏后")
public class UserVO extends BaseViewModel implements Serializable {

    private static final long serialVersionUID = 5583360083063856158L;

    @ApiModelProperty("用户账号")
    private String username;

    @ApiModelProperty("用户姓氏")
    private String lastName;

    @ApiModelProperty("用户名称")
    private String firstName;

    @ApiModelProperty("手机号")
    private String mobile;

    @ApiModelProperty("电子邮箱")
    private String email;

}
