package com.elitescloud.cloudt.comm.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author Chris
 * 2021-03-24
 */
@Data
@ApiModel(description = "区域：省市区")
public class ComCityCodeVO implements Serializable {

    private static final long serialVersionUID = 6072014098756139935L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty("区域名称")
    private String areaName;

    @ApiModelProperty("区域代码")
    private String areaCode;

    @ApiModelProperty("区域等级")
    private String areaLevel;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("上级ID")
    private Long pid;

    @ApiModelProperty("区号")
    private String telHead;

    @ApiModelProperty("邮编")
    private String zipCode;

    @ApiModelProperty("是否是最后一级：true是有，false是没有")
    private Boolean isLeaf;

    private List<ComCityCodeVO> areas;
}
