package com.elitescloud.cloudt.comm.vo.resp;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 税率
 */
@Data
@ApiModel(value = "税率", description = "税率")
public class ComTaxRateRespVO  implements Serializable {
    private static final long serialVersionUID = -7197577625040996865L;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    /**
     * 税率编号
     */
    @ApiModelProperty("税率编号")
    private String taxRateNo;

    /**
     * 税率说明
     */
    @ApiModelProperty("税率说明")
    private String taxRateDesc;

    /**
     * 生效日期
     */
    @ApiModelProperty("生效日期")
    private LocalDateTime validFrom;

    /**
     * 失效日期
     */
    @ApiModelProperty("失效日期")
    private LocalDateTime validTo;

    /**
     * 税率值
     */
    @ApiModelProperty("税率值")
    private Double taxRateValue;

    /**
     * 税率索引
     */
    @ApiModelProperty("税率索引")
    @SysCode(sys = "COM", mod = "TAX_RATE_INDEX")
    private String taxRateIndex;

    /**
     * 税率索引名称
     */
    @ApiModelProperty("税率索引 名称")
    private String taxRateIndexName;

    /**
     * 账号唯一ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("账号唯一ID")
    private Long id;

    /**
     * 租户ID
     */
    @ApiModelProperty(value = "租户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long tenantId;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    /***
     * 创建用户ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime ;

    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;

    /**
     * 最后更新时间
     */
    private LocalDateTime modifyTime;

    /**
     * 逻辑删除
     */
    @ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;

    /**
     * 操作人姓名
     */
    @ApiModelProperty("操作人姓名")
    private String operUserName;

}
