package com.elitescloud.cloudt.system.dto.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import java.io.Serializable;

/**
 * 导入进度.
 *
 * @author Kaiser（wang shao）
 * @date 2021/6/2
 */
@Data
@ApiModel(description = "导入进度")
@Builder
public class ImportRateRespVO implements Serializable {
    private static final long serialVersionUID = -6447608047256329586L;

    public ImportRateRespVO(Boolean finish, Long total, Long count, String rate) {
        this.finish = finish;
        this.total = total;
        this.count = count;
        this.rate = rate;
    }

    public ImportRateRespVO() {
    }

    /**
     * 是否导入完毕
     */
    @ApiModelProperty(value = "是否导入完毕")
    private Boolean finish;

    /**
     * 记录总数
     */
    @ApiModelProperty(value = "记录总数")
    private Long total;

    /**
     * 已导入数量
     */
    @ApiModelProperty(value = "已导入数量")
    private Long count;

    /**
     * 导入进度（百分比形式）
     */
    @ApiModelProperty(value = "导入进度")
    private String rate;
}
