package com.elitescloud.cloudt.system.provider;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 用户权限.
 *
 * @author Kaiser（wang shao）
 * @date 2/23/2023
 */
@FeignClient(name = Application.NAME, path = SysUserPermissionRpcService.URI)
@Validated
public interface SysUserPermissionRpcService {
    String URI = Application.URI_PREFIX + "/userPermission";

    /**
     * 保存用户角色
     *
     * @param userId  用户ID
     * @param roleIds 角色ID
     * @return 用户ID
     */
    @PostMapping(value = "/saveUserRoles")
    ApiResult<Long> saveUserRoles(@NotNull(message = "用户ID为空") @RequestParam(name = "userId") Long userId,
                                  @RequestBody List<Long> roleIds);
}
