package com.elitescloud.cloudt.system.provider.extend;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.SysAreaQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysAreaRespDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;
import java.util.Set;

/**
 * 行政区域服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 3/3/2023
 */
@FeignClient(name = Application.NAME, path = SysAreaRpcService.URI)
@Validated
public interface SysAreaRpcService {
    String URI = Application.URI_PREFIX + "/area";

    /**
     * 根据编号查询行政区域
     *
     * @param areaCodes 行政区域编码
     * @return 行政区域列表
     */
    @PostMapping(value = "/listByAreaCodes")
    ApiResult<List<SysAreaRespDTO>> listByAreaCodes(@RequestBody @NotEmpty(message = "行政区域编码为空") Set<String> areaCodes);

    /**
     * 根据上级行政区域编码查询行政区域
     *
     * @param areaCode 上级行政区域编码
     * @return 行政区域列表
     */
    @GetMapping(value = "/listByParentAreaCode")
    ApiResult<List<SysAreaRespDTO>> listByParentAreaCode(@NotBlank(message = "上级行政区域编码为空") @RequestParam(value = "areaCode") String areaCode);

    /**
     * 查询行政区域
     *
     * @param queryDTO 查询参数
     * @return 行政区域列表
     */
    @PostMapping(value = "/queryList")
    ApiResult<List<SysAreaRespDTO>> queryList(@RequestBody SysAreaQueryDTO queryDTO);
}
