package com.elitescloud.cloudt.system.provider.org;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 员工组服务.
 *
 * @author Kaiser（wang shao）
 * @date 2/14/2023
 */
@FeignClient(name = Application.NAME, path = EmployeeGroupRpcService.URI)
@Validated
public interface EmployeeGroupRpcService {
    String URI = Application.URI_PREFIX + "/emp_group";

    /**
     * 根据员工组查询用户ID
     * <p>
     * 查询员工组下的员工的用户ID
     *
     * @param groupCode 员工组编号
     * @return 用户ID列表
     */
    @GetMapping(value = "/getUserIdsByGroupCode")
    ApiResult<List<Long>> getUserIdsByGroupCode(@NotBlank(message = "员工组编号为空") @RequestParam(value = "groupCode") String groupCode);
}
