package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.system.param.SysButableQParam;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysTableVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.util.List;

@FeignClient(name = Application.NAME, path = SysButableService.URI)
@Validated
public interface SysButableService {
    String URI = Application.URI_PREFIX + "/butable";

    /**
     * 查询所有需要配置 bu_id 使用的表记录
     *
     * @return
     */
    @GetMapping(value = "/listButable")
    List<SysTableVO> listButable();

    @PostMapping(value = "/search")
    PagingVO<SysTableVO> search(@RequestBody SysButableQParam sysButableQParam);

    /**
     * 创建butable
     *
     * @param sysTableVO
     * @return
     */
    @PostMapping(value = "/create")
    Long create(@RequestBody SysTableVO sysTableVO);

    @PostMapping(value = "/update")
    void update(@RequestBody SysTableVO sysTableVO);

    /**
     * 逻辑删除
     *
     * @param id
     */
    @DeleteMapping(value = "/logicDelete")
    void logicDelete(@RequestParam(value = "id") @NotNull(message = "ID为空") Long id);
}
