package com.elitescloud.cloudt.system.provider;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 发号器.
 *
 * @author Kaiser（wang shao）
 * 2022/11/15
 */
@FeignClient(name = Application.NAME, path = SysSeqNumRpcService.URI)
@Validated
public interface SysSeqNumRpcService {
    String URI = Application.URI_PREFIX + "/seqNum";

    /**
     * 生成示例代码
     *
     * @param appCode       应用编码
     * @param ruleCode      发号规则
     * @param runtimeValues 运行时参数
     * @return
     */
    @PostMapping(value = "/generate/sampleCode/byCode")
    ApiResult<String> generateSampleCode(@NotBlank(message = "应用编码为空") @RequestParam(name = "appCode") String appCode,
                                         @NotBlank(message = "发号规则编码为空") @RequestParam(name = "ruleCode") String ruleCode,
                                         @RequestBody List<String> runtimeValues);

    /**
     * 生成示例代码
     *
     * @param ruleId        发号规则ID
     * @param runtimeValues 运行时参数
     * @return
     */
    @PostMapping(value = "/generate/sampleCode")
    ApiResult<String> generateSampleCode(@NotBlank(message = "发号规则ID为空") @RequestParam(name = "ruleId") Long ruleId,
                                         @RequestBody List<String> runtimeValues);

    /**
     * 生成下一代码
     *
     * @param appCode       应用编码
     * @param ruleCode      发号规则
     * @param runtimeValues 运行时参数
     * @return
     */
    @PostMapping(value = "/generate/code/byCode")
    ApiResult<String> generateCode(@NotBlank(message = "应用编码为空") @RequestParam(name = "appCode") String appCode,
                                   @NotBlank(message = "发号规则编码为空") @RequestParam(name = "ruleCode") String ruleCode,
                                   @RequestBody List<String> runtimeValues);

    /**
     * 生成下一代码
     *
     * @param ruleId        发号规则ID
     * @param runtimeValues 运行时参数
     * @return
     */
    @PostMapping(value = "/generate/code")
    ApiResult<String> generateCode(@NotBlank(message = "发号规则ID为空") @RequestParam(name = "ruleId") Long ruleId,
                                   @RequestBody List<String> runtimeValues);

    /**
     * 生成下一序号
     *
     * @param nextNumberId 下一序号ID
     * @param len          下一序号的最大宽度
     * @return 下一序号
     */
    @GetMapping(value = "/generate/nextNumber")
    ApiResult<Long> generateNextNumber(@NotNull(message = "下一序号ID为空") @RequestParam(name = "nextNumberId") Long nextNumberId,
                                       @RequestParam(name = "len", required = false) Integer len);


    /**
     * 生成下一序号
     *
     * @param appCode        应用编码
     * @param nextNumberCode 下一序号的编码
     * @param len            下一序号的最大宽度
     * @return 下一序号
     */
    @GetMapping(value = "/generate/nextNumber/byCode")
    ApiResult<Long> generateNextNumber(@NotBlank(message = "应用编码为空") @RequestParam(name = "appCode") String appCode,
                                       @NotBlank(message = "下一序号的编码为空") @RequestParam(name = "nextNumberCode") String nextNumberCode,
                                       @RequestParam(name = "len", required = false) Integer len);
}
