package com.elitescloud.cloudt.system.provider.extend;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.SysCurrencyQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;
import java.util.Set;

/**
 * 币种服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 3/3/2023
 */
@FeignClient(name = Application.NAME, path = SysCurrencyRpcService.URI)
@Validated
public interface SysCurrencyRpcService {
    String URI = Application.URI_PREFIX + "/currency";

    /**
     * 根据币种编码获取币种信息
     *
     * @param currCode 币种编码
     * @return 币种信息
     */
    @GetMapping(value = "/getByCode")
    ApiResult<SysCurrencyRespDTO> getByCode(@NotBlank(message = "币种编码为空") @RequestParam(name = "currCode") String currCode);

    /**
     * 根据编码查询币种
     *
     * @param currCodes 币种编码
     * @return 币种信息列表
     */
    @PostMapping(value = "/listByCodes")
    ApiResult<List<SysCurrencyRespDTO>> listByCodes(@RequestBody @NotEmpty(message = "币种编码为空") Set<String> currCodes);

    /**
     * 查询币种
     *
     * @param queryDTO 查询参数
     * @return 币种信息列表
     */
    @PostMapping(value = "/queryList")
    ApiResult<List<SysCurrencyRespDTO>> queryList(@RequestBody SysCurrencyQueryDTO queryDTO);
}
