package com.elitescloud.cloudt.system.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Set;

/**
 * <p>
 * 功能说明
 * </p >
 *
 * @author niu.chen
 * 2021-07-07
 */
@Data
@ApiModel("数据角色权限对象")
public class SysDataAuthVO implements Serializable {

    private static final long serialVersionUID = 666038826536409244L;

    /**
     * 是不是全部查看
     */
    private Boolean isAll = false;

    /**
     * 是否启用组织授权
     */
    private Boolean buAuthEnable = false;

    /**
     * 组织授权方式
     */
    private SysDataRoleAuthScope buDataAuthScope;

    /**
     * 是否启用员工授权
     */
    @ApiModelProperty("是否启用员工授权")
    private Boolean empAuthEnable = false;

    /**
     * 员工授权方式
     */
    private SysDataRoleAuthScope userDataAuthScope;

    /**
     * 是否启用公司授权
     */
    @ApiModelProperty("是否启用公司授权")
    private Boolean ouAuthEnable = false;

    /**
     * 关联的数据角色ID
     */
    private Long dataRoleId;

    /**
     * 是否基础数据授权：1 是，0 否
     */
    private Boolean isBasic;

    /**
     * 高级授权应用ID
     */
    private Long permissionId;

    /**
     * 高级授权应用Code
     */
    private String permissionCode;

    /**
     * 自定义授权的组织id
     */
    private Set<Long> buIdSet;

    /**
     * 自定义授权的账号id
     */
    private Set<Long> userIdSet;

    /**
     * 自定义授权的公司id
     */
    private Set<Long> ouIdSet;
}
