package com.elitescloud.cloudt.system.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <pre>
 * [功能说明]
 * </pre>
 *
 * @author Michael Li
 * @date 2020/7/10
 */
@Data
@ApiModel("权限-菜单、操作的更新信息对象")
public class SysPermissionUpdateParam implements Serializable {

    private static final long serialVersionUID = 2260563011064291483L;

    /**
     * 权限ID
     */
    @ApiModelProperty("权限ID")
    private Long id;

    /**
     * 父级菜单ID
     */
    @ApiModelProperty("父级菜单ID")
    private Long parentId;

    /**
     * 权限代码
     */
    @ApiModelProperty("权限代码")
    private String code;

    /**
     * 权限名称
     */
    @ApiModelProperty("权限名称")
    private String name;

    /**
     * 权限路径模板
     */
    @ApiModelProperty("权限路径模板")
    private String pattern;

    /**
     * 权限路径HTTP方法
     */
    @ApiModelProperty("权限路径HTTP方法")
    private String httpMethod;

    /**
     * 排列顺序
     */
    @ApiModelProperty("排列顺序")
    private Integer sortNo;

    /**
     * 菜单是否隐藏
     */
    @ApiModelProperty(value = "菜单是否隐藏")
    private Boolean isHidden;

    /**
     * 菜单图标
     */
    @ApiModelProperty(value = "菜单图标")
    private String icon;
}
