package com.elitescloud.cloudt.system.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;

/**
 * <pre>
 * [功能说明]
 * </pre>
 *
 * @author Michael Li
 * @date 2020/7/18
 */
@Data
@Accessors(chain = true)
@ApiModel("用户账号创建对象")
public class SysUserSave implements Serializable {

    private static final long serialVersionUID = -8450631746913086288L;
    @ApiModelProperty(value = "用户账号名称")
    String username;

    @ApiModelProperty(value = "用户姓氏")
    String lastName;

    @ApiModelProperty(value = "用户名称")
    String firstName;

    @ApiModelProperty(value = "用户手机号码")
    String mobile;

    @ApiModelProperty(value = "用户邮箱地址")
    String email;

    @ApiModelProperty(value = "用户账号密码")
    String password;

    @ApiModelProperty(value = "是否启用")
    Boolean enabled;

    @ApiModelProperty("角色ID列表")
    Optional<List<Long>> roleIds;

    /**
     * <Strong>Mir 2020-09-15 增加账号信息来源字段，默认sys，由系统创建</Strong>
     */
    @ApiModelProperty("账号来源, sys： 系统创建；wec：微信创建；oth：其他方式")
    String sourceType;
}
