package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.system.dto.SysNumberRuleDtlDTO;
import com.elitescloud.cloudt.system.vo.SysNumberRuleDtlVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 发号器规则明细
 *
 * @author Michael Li
 * @date 2020-10-11
 */
@FeignClient(name = Application.NAME, path = SysNumberRuleDtlService.URI)
@Validated
public interface SysNumberRuleDtlService {
    String URI = Application.URI_PREFIX + "/numberRuleDtl";

    /**
     * 根据规则ID列出明细，按seq排序
     *
     * @param ruleId 规则ID
     * @return 规则明细列表
     */
    @GetMapping(value = "/listByRuleId")
    List<SysNumberRuleDtlVO> listByRuleId(@RequestParam(value = "ruleId") @NotNull(message = "规则ID为空") Long ruleId);

    /**
     * 根据规则ID获取规则信息
     *
     * @param ruleId 规则ID
     * @return 规则信息
     */
    @GetMapping(value = "/listDtoByRuleId")
    List<SysNumberRuleDtlDTO> listDtoByRuleId(@RequestParam(value = "ruleId") @NotNull(message = "规则ID为空") Long ruleId);
}
