package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.system.param.SysPermissionNewParam;
import com.elitescloud.cloudt.system.param.SysPermissionUpdateParam;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.system.vo.AntTreeNode;
import com.elitescloud.cloudt.system.vo.SysPermissionVO;
import com.elitescloud.cloudt.system.vo.SysPermissionWithRoleVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Set;

/**
 * 权限服务接口
 *
 * @author Michael Li
 * @date 2020/7/5
 */
@FeignClient(name = Application.NAME, path = SysPermissionService.URI)
@Validated
public interface SysPermissionService {
    String URI = Application.URI_PREFIX + "/permission";

    @PostMapping(value = "/createMenu")
    Long createMenu(@RequestBody SysPermissionNewParam permission) throws BusinessException;

    @PostMapping(value = "/createAction")
    Long createAction(@RequestBody SysPermissionNewParam permission) throws BusinessException;

    @PostMapping(value = "/update")
    void update(@RequestBody SysPermissionUpdateParam perm);

    @GetMapping(value = "/listAllMenuTree")
    List<AntTreeNode> listAllMenuTree();

    @GetMapping(value = "/listAllMenuWithActionTree")
    List<AntTreeNode> listAllMenuWithActionTree();

    @GetMapping(value = "/listAllMenuWithActionTreeByPermId")
    List<AntTreeNode> listAllMenuWithActionTree(@RequestParam(value = "permId", required = false) Long permId);

    @PostMapping(value = "/listAllPermissionsByIds")
    Set<SysPermissionVO> listAllPermissionsByIds(@RequestBody List<Long> ids);

    @PostMapping(value = "/listPermTreeByIds")
    List<AntTreeNode> listPermTreeByIds(@RequestBody List<Long> ids);

    @GetMapping(value = "/listActionsByMenuId")
    List<SysPermissionVO> listActionsByMenuId(@RequestParam(value = "id", required = false) Long id);

    @GetMapping(value = "/findAllByPermType")
    List<SysPermissionVO> findAllByPermType(@RequestParam(value = "id") @NotNull(message = "菜单级别为空") Integer permType);

    @GetMapping(value = "/findAll")
    List<SysPermissionVO> findAll();

    @GetMapping(value = "/listAllPermissionsWithRoles")
    List<SysPermissionWithRoleVO> listAllPermissionsWithRoles();

    /**
     * 刷新权限信息：redis
     * @return
     */
    @GetMapping(value = "/refreshPermissionRolesCache")
    boolean refreshPermissionRolesCache();
}
