package com.elitescloud.cloudt.system.vo;

import com.elitescloud.cloudt.common.constant.Terminal;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author Chris
 * @date 2021-07-19
 */
@Data
@ApiModel("用户详情VO")
public class SysUserDetailsVO implements Serializable {

    private static final long serialVersionUID = -356900683285644616L;

    /**
     * 用户ID
     */
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "用户ID")
    Long id;

    /**
     * 用户姓氏
     */
    @ApiModelProperty(value = "用户姓氏")
    String lastName;

    /**
     * 用户名称
     */
    @ApiModelProperty(value = "用户名称")
    String firstName;

    /**
     * 用户手机号码
     */
    @ApiModelProperty(value = "用户手机号码")
    String mobile;

    /**
     * 用户邮箱地址
     */
    @ApiModelProperty(value = "用户邮箱地址")
    String email;

    /**
     * 用户账号密码
     */
    @ApiModelProperty(value = "用户账号密码")
    String password;

    /**
     * 是否启动
     */
    @ApiModelProperty(value = "是否启动")
    Boolean enabled;

    /**
     * 用户所属公司ID
     */
    @ApiModelProperty("用户所属公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    /**
     * 用户所属公司编号
     */
    @ApiModelProperty("用户所属公司编号")
    private String ouCode;

    /**
     * 用户所属公司名称
     */
    @ApiModelProperty("用户所属公司名称")
    private String ouName;

    /**
     * 用户所属组织ID
     */
    @ApiModelProperty("用户所属组织ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    /**
     * 功能角色ID列表
     */
    @ApiModelProperty("功能角色ID列表")
    List<String> roleIds;

    /**
     * 数据角色ID列表
     */
    @ApiModelProperty("数据角色ID列表")
    List<String> dataRoleIds;

    /**
     * 流程角色ID列表
     */
    @ApiModelProperty("流程角色ID列表")
    List<String> flowRoleIds;

    @ApiModelProperty(value = "用户头像地址，可直接访问，如微信头像地址等", position = 11)
    private String avatarUrl;

    @ApiModelProperty(value = "用户头像编码，图片在文件服务器中的标识，与avatarUrl二选一即可", position = 11)
    private String avatarCode;

    /**
     * 用户的终端
     */
    @ApiModelProperty("用户终端")
    private List<Terminal> terminals;
}
