/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.common.exception.BusinessException;
import com.elitescloud.cloudt.system.param.SysPermissionNewParam;
import com.elitescloud.cloudt.system.param.SysPermissionUpdateParam;
import com.elitescloud.cloudt.system.vo.AntTreeNode;
import com.elitescloud.cloudt.system.vo.SysPermissionVO;
import com.elitescloud.cloudt.system.vo.SysPermissionWithRoleVO;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="cloudt-system", path="/rpc/cloudt/system/permission")
@Validated
public interface SysPermissionService {
    public static final String URI = "/rpc/cloudt/system/permission";

    @PostMapping(value={"/createMenu"})
    public Long createMenu(@RequestBody SysPermissionNewParam var1) throws BusinessException;

    @PostMapping(value={"/createAction"})
    public Long createAction(@RequestBody SysPermissionNewParam var1) throws BusinessException;

    @PostMapping(value={"/update"})
    public void update(@RequestBody SysPermissionUpdateParam var1);

    @GetMapping(value={"/listAllMenuTree"})
    public List<AntTreeNode> listAllMenuTree();

    @GetMapping(value={"/listAllMenuWithActionTree"})
    public List<AntTreeNode> listAllMenuWithActionTree();

    @GetMapping(value={"/listAllMenuWithActionTreeByPermId"})
    public List<AntTreeNode> listAllMenuWithActionTree(@RequestParam(value="permId", required=false) Long var1);

    @PostMapping(value={"/listAllPermissionsByIds"})
    public Set<SysPermissionVO> listAllPermissionsByIds(@RequestBody List<Long> var1);

    @PostMapping(value={"/listPermTreeByIds"})
    public List<AntTreeNode> listPermTreeByIds(@RequestBody List<Long> var1);

    @GetMapping(value={"/listActionsByMenuId"})
    public List<SysPermissionVO> listActionsByMenuId(@RequestParam(value="id", required=false) Long var1);

    @GetMapping(value={"/findAllByPermType"})
    public List<SysPermissionVO> findAllByPermType(@RequestParam(value="id") @NotNull(message="\u83dc\u5355\u7ea7\u522b\u4e3a\u7a7a") @NotNull(message="\u83dc\u5355\u7ea7\u522b\u4e3a\u7a7a") Integer var1);

    @GetMapping(value={"/findAll"})
    public List<SysPermissionVO> findAll();

    @GetMapping(value={"/listAllPermissionsWithRoles"})
    public List<SysPermissionWithRoleVO> listAllPermissionsWithRoles();

    @GetMapping(value={"/refreshPermissionRolesCache"})
    public boolean refreshPermissionRolesCache();
}

