package com.elitescloud.cloudt.comm.vo.param;


import com.elitescloud.cloudt.common.base.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

@Data
@ApiModel(value = "税率", description = "税率")
public class ComTaxRateQueryParamVO extends AbstractOrderQueryParam implements Serializable {

    private static final long serialVersionUID = -7197577625040996865L;

    @ApiModelProperty("id")
    @JsonSerialize(using = ToStringSerializer.class)
    Long id;

    @ApiModelProperty("税率编号")
    String taxRateNo;

    @ApiModelProperty("税率说明")
    String taxRateDesc;

    @ApiModelProperty("生效开始日期")
    LocalDateTime validFromS;

    @ApiModelProperty("生效结束日期")
    LocalDateTime validFromE;

    @ApiModelProperty("失效开始日期")
    LocalDateTime validToS;

    @ApiModelProperty("失效结束日期")
    LocalDateTime validToE;

    @ApiModelProperty("税率值")
    Float taxRateValue;

    @ApiModelProperty("税率索引")
    String taxRateIndex;

}
