package com.elitescloud.cloudt.system.param;

import com.elitescloud.cloudt.common.constant.Terminal;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;

/**
 * <pre>
 * [功能说明]
 * </pre>
 *
 * @author Michael Li
 * @date 2020/7/18
 */
@Data
@Accessors(chain = true)
@ApiModel("用户账号更新对象")
public class SysUserUpdateParam implements Serializable {

    private static final long serialVersionUID = 5422814991678473995L;

    /**
     * 用户ID
     */
    @ApiModelProperty(value = "用户ID")
    private Long id;

    /**
     * 用户姓氏
     */
    @ApiModelProperty(value = "用户姓氏")
    private String lastName;

    /**
     * 用户名称
     */
    @ApiModelProperty(value = "用户名称")
    private String firstName;

    /**
     * 用户手机号码
     */
    @ApiModelProperty(value = "用户手机号码")
    private String mobile;

    /**
     * 用户邮箱地址
     */
    @ApiModelProperty(value = "用户邮箱地址")
    private String email;


    @ApiModelProperty("所属租户ID")
    private String tenantId;

    @ApiModelProperty("所属租户名称")
    private String tenantName;

    /**
     * 是否启动
     */
    @ApiModelProperty(value = "是否启动")
    private Boolean enabled;

    /**
     * 用户所属公司ID
     */
    @ApiModelProperty("用户所属公司ID")
    private Long ouId;

    /**
     * 用户所属公司编号
     */
    @ApiModelProperty("用户所属公司编号")
    private String ouCode;

    /**
     * 用户所属公司名称
     */
    @ApiModelProperty("用户所属公司名称")
    private String ouName;

    /**
     * 用户所属组织ID
     */
    @ApiModelProperty("用户所属组织ID")
    private Long buId;

    /**
     * 功能角色ID列表
     */
    @ApiModelProperty("功能角色ID列表")
    private List<Long> roleIds;

    /**
     * 数据角色ID列表
     */
    @ApiModelProperty("数据角色ID列表")
    private List<Long> dataRoleIds;

    /**
     * 流程角色ID列表
     */
    @ApiModelProperty("流程角色ID列表")
    private List<Long> flowRoleIds;

    /**
     * 用户终端
     * 可登录的端
     */
    @ApiModelProperty("用户终端, BACKEND： 管理端；APP：移动端")
    private Set<Terminal> terminals;

    /**
     * 账号过期时间
     */
    @ApiModelProperty("账号过期时间")
    private LocalDateTime expiredTime;
}
