package com.elitescloud.cloudt.system.provider.param;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author Chris
 * @date 2021-08-27
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SysUserRpcDtoParam implements Serializable {

    private static final long serialVersionUID = -3949030165617373689L;

    /**
     * 用户ID
     */
    private List<Long> userIds;

    /**
     * 用户名
     */
    private List<String> usernames;

    /**
     * 邮箱地址
     */
    private List<String> emails;

    /**
     * 手机号
     */
    private List<String> mobiles;

    /**
     * 来源
     */
    private List<String> sourceTypes;

    /**
     * 应用角色ID列表
     */
    private List<Long> roleIds;

    /**
     * 是否启用
     */
    private Boolean enabled;
}
