package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.system.param.SysNumberRuleQParam;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysNumberRuleVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 发号器规则
 *
 * @author Michael Li
 * @date 2020-10-11
 */
@FeignClient(name = Application.NAME, path = SysNumberRuleService.URI)
@Validated
public interface SysNumberRuleService {
    String URI = Application.URI_PREFIX + "/numberRule";

    /**
     * 根据发号规则ID，生成样例号
     *
     * @param ruleId        发号规则ID
     * @param runtimeValues 基于UDC选择值的列表
     * @return 生成样例号，下一编号用默认，1
     */
    @PostMapping(value = "/generateSampleCode")
    String generateSampleCode(@RequestParam(value = "ruleId") @NotNull(message = "规则ID为空") Long ruleId,
                              @RequestBody List<String> runtimeValues);

    /**
     * 根据发号规则编码，生成样例号
     *
     * @param ruleCode      发号规则编码
     * @param runtimeValues 基于UDC选择值的列表
     * @return 生成样例号，洗衣编号默认用，1
     */
    @PostMapping(value = "/generateSampleCodeByRuleCode")
    String generateSampleCode(@RequestParam(value = "ruleCode") @NotBlank(message = "发号规则编码为空") String ruleCode,
                              @RequestBody List<String> runtimeValues);

    /**
     * 根据发号规则ID，生成对应号码
     *
     * @param ruleId        发号规则ID
     * @param runtimeValues 选择的UDC的值列表
     * @return 生成的号码
     */
    @PostMapping(value = "/generateCode")
    String generateCode(@RequestParam(value = "ruleId") @NotBlank(message = "发号器规则ID为空") Long ruleId,
                        @RequestBody List<String> runtimeValues);

    /**
     * 根据发号规则编码，生成对应号码
     *
     * @param ruleCode      发号规则编码
     * @param runtimeValues 选择UDC的值列表
     * @return 生成的号码
     */
    @PostMapping(value = "/generateCodeByRuleCode")
    String generateCode(@RequestParam(value = "ruleCode") @NotBlank(message = "发号规则编码为空") String ruleCode,
                        @RequestBody List<String> runtimeValues);

    /**
     * 检索发号器规则
     *
     * @param param 检索条件对象
     * @return 分页的规则集合
     */
    @PostMapping(value = "/search")
    PagingVO<SysNumberRuleVO> search(@RequestBody SysNumberRuleQParam param);
}
