package com.elitescloud.cloudt.system.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author mir
 */
@Data
@ApiModel(value = "业务数据权限约束", description = "业务数据权限约束")
public class SysBizDataConstraintVO implements Serializable {

    private static final long serialVersionUID = 9171917438699985947L;
    @ApiModelProperty("元数据列的记录ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long metaColumnId;

    @ApiModelProperty(value = "数据角色编码")
    private String dataRoleCode;

    @ApiModelProperty(value = "数据角色名称")
    private String dataRoleName;

    @ApiModelProperty(value = "领域编码")
    String domainCode;

    @ApiModelProperty(value = "领域名称")
    String domainName;

    @ApiModelProperty(value = "表编码")
    String tableCode;

    @ApiModelProperty(value = "表名称")
    String tableName;

    @ApiModelProperty(value = "表字段编码")
    String fieldCode;

    @ApiModelProperty(value = "字段名称")
    String fieldCaption;

    @ApiModelProperty(value = "字段类型")
    String fieldType;

    @ApiModelProperty(value = "逻辑字段类型META:FLDTYPE")
    String fieldUdcType;

    @ApiModelProperty(value = "UDC的Domain Code")
    String udcDomainCode;

    @ApiModelProperty(value = "UDC的UDC Code")
    String udcCode;

    @ApiModelProperty(value = "默认值")
    String defaultValue;

    @ApiModelProperty(value = "比较符编码")
    private String compareOpCode;

    @ApiModelProperty(value = "比较符名称")
    private String compareOpName;

    @ApiModelProperty(value = "约束值, 多值采用逗号分隔")
    private String constraintValues;
}
