package com.elitescloud.cloudt.comm.service;

import com.elitescloud.cloudt.comm.consumer.dto.ComTaxRateRpcDTO;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.comm.consumer.param.ComTaxRateRpcDtoParam;
import com.elitescloud.cloudt.comm.vo.param.ComCommonTaxRateQueryParamVO;
import com.elitescloud.cloudt.comm.vo.param.ComTaxRateQueryParamDTO;
import com.elitescloud.cloudt.comm.vo.param.ComTaxRateQueryParamVO;
import com.elitescloud.cloudt.comm.vo.resp.ComCommonTaxRateRespVO;
import com.elitescloud.cloudt.comm.vo.resp.ComTaxRateRespVO;
import com.elitescloud.cloudt.comm.vo.resp.ComTaxRateVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;
import java.util.Set;

/**
 * 税率
 *
 * @author zhenghaiyang
 * @date 2020/7/2
 */
@FeignClient(name = Application.NAME, path = ComTaxRateProviderService.URI)
@Validated
public interface ComTaxRateProviderService {
    String URI = Application.URI_PREFIX + "/taxRate";

    @PostMapping(value = "/findBytaxRateNoList")
    List<ComTaxRateVO> findBytaxRateNoList(@RequestBody List<String> strings);

    /**
     * 查找税率共通方法
     *
     * @param param 单个入参
     * @return 返回 单个税率
     * @author 常昊阳 haoyang.chang@elitesland.com
     */
    @PostMapping(value = "/getRatioOrNull")
    ComCommonTaxRateRespVO getRatioOrNull(@RequestBody ComCommonTaxRateQueryParamVO param);

    /**
     * 根据税率编号及索引查询唯一税率 liuqi 2020.10.23
     *
     * @param taxRateNo    税率编号
     * @param taxRateIndex 税率索引
     * @return 税率
     */
    @GetMapping(value = "/findByTaxRateNoAndIndexOrNull")
    ComTaxRateVO findByTaxRateNoAndIndexOrNull(@RequestParam(value = "taxRateNo") @NotBlank(message = "税率编号为空") String taxRateNo,
                                               @RequestParam(value = "taxRateIndex") @NotBlank(message = "税率索引为空") String taxRateIndex);

    /**
     * @param taxRateNo, taxRateIndex
     * @return java.util.Optional<com.elitesland.basic.vo.ComTaxRateVO>
     * @Author Kevin.yuan
     * @Data 2020/12/10 10:10
     **/
    @GetMapping(value = "/findBytaxRateNoInAndIndexIn")
    List<ComTaxRateRespVO> findBytaxRateNoInAndIndexIn(@RequestParam(value = "taxRateNo") @NotEmpty(message = "税率编号为空") Set<String> taxRateNo,
                                                       @RequestParam(value = "taxRateIndex") @NotEmpty(message = "税率索引为空") Set<String> taxRateIndex);

    @PostMapping(value = "/searchAll")
    PagingVO<ComTaxRateRespVO> searchAll(@RequestBody ComTaxRateQueryParamVO param);

    /**
     * 检索
     *
     * @param queryParam 分类查询、分页和排序对象
     * @return 分页结果集
     */
    @PostMapping(value = "/search")
    PagingVO<ComTaxRateRespVO> search(@RequestBody ComTaxRateQueryParamVO queryParam);

    /**
     * 根据关键字段，返回对应的vo
     *
     * @param code code
     * @return 对象
     */
    @GetMapping(value = "/getCodeOne")
    ComTaxRateRespVO getCodeOne(@RequestParam(value = "code") @NotBlank(message = "编码为空") String code);

    /**
     * 根据关键字段，返回对应的
     *
     * @param id ID
     * @return 对象
     */
    @GetMapping(value = "/getIdOne")
    ComTaxRateRespVO getIdOne(@RequestParam(value = "id") @NotBlank(message = "ID为空") Long id);

    /**
     * 根据关键字段，返回对应的
     *
     * @param idList ID集合
     * @return 对象
     */
    @PostMapping(value = "/idList")
    List<ComTaxRateRespVO> findIdBatch(@RequestBody List<Long> idList);

    /**
     * 查询税率
     *
     * @param queryParamDTO 查询参数
     * @return 税率列表
     */
    @PostMapping(value = "/query")
    List<ComTaxRateRespVO> query(@RequestBody ComTaxRateQueryParamDTO queryParamDTO);

    /**
     * 获取税率信息列表，该接口一般应用与如下场景
     * 1. 第三方通过code获取一些基本信息，用于后端组装数据
     * 2. 检查数据是否存在，存在则会返回数据，不存在则不会返回数据
     * <p>
     * 如果传入的查询参数均为空，则不返回任何数据，防止获取全部数据
     * <p>
     * 注意接口返回数据没有上限控制，请合理使用，保证效能
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 查询条件，每个条件使用 and 关联
     * @return dto
     */
    @PostMapping(value = "/findTaxRateRpcDtoByParam")
    List<ComTaxRateRpcDTO> findTaxRateRpcDtoByParam(@RequestBody ComTaxRateRpcDtoParam param);
}
