package com.elitescloud.cloudt.comm.vo.save;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <pre>
 * [功能说明]
 * </pre>
 *
 * @author Mir
 * @date 2020/7/31
 */
@Data
@ApiModel("区域视图对象")
public class ComDistrictSaveVO implements Serializable {

    private static final long serialVersionUID = 6361731875736667356L;

    @ApiModelProperty("区域ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long id;

    @ApiModelProperty(value = "区划代码")
    String distCode;

    @ApiModelProperty(value = "区划名称")
    String distName;

    @ApiModelProperty(value = "区划名称2")
    String distName2;

    @ApiModelProperty(value = "区划类型")
    String distType;

    @ApiModelProperty(value = "区划类型2")
    String distType2;

    @ApiModelProperty(value = "区划类型3")
    String distType3;

    @ApiModelProperty(value = "区划简称")
    String abbrName;

    @ApiModelProperty(value = "国家码: COM:COUNTRY")
    String country;

    @ApiModelProperty(value = "国家名称: COM:COUNTRY")
    String countryName;

    @ApiModelProperty(value = "国家名称ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long countryId;

    @ApiModelProperty(value = "省份、州码")
    String province;

    @ApiModelProperty(value = "省份、州名称 ")
    String provinceName;

    @ApiModelProperty(value = "省份、州名id ")
    @JsonSerialize(using = ToStringSerializer.class)
    Long provinceId;

    @ApiModelProperty(value = "城市码：COM:CITY")
    String city;

    @ApiModelProperty(value = "城市名称：COM:CITY")
    String cityName;
    @ApiModelProperty(value = "城市名称id")
    @JsonSerialize(using = ToStringSerializer.class)
    Long cityId;

    @ApiModelProperty(value = "区县码: COM:COUNTY")
    String county;

    @ApiModelProperty(value = "乡镇街道")
    String street;

    @ApiModelProperty(value = "区域等级")
    String distLevel;

    @ApiModelProperty(value = "区域等级数值")
    Integer distLevelNum;

    @ApiModelProperty(value = "上级ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long parentId;

    @ApiModelProperty(value = "上级代码")
    String parentCode;

    @ApiModelProperty(value = "路径")
    String path;

    @ApiModelProperty(value = "地址状态")
    String distStatus;

    @ApiModelProperty(value = "汉语拼音")
    String distPinyin;

    @ApiModelProperty(value = "拼音首字母")
    String distPinyinCaps;

    @ApiModelProperty(value = "电话区号")
    String telHead;

    @ApiModelProperty(value = "邮编")
    String zipCode;

    @ApiModelProperty(value = "区域描述")
    String distDesc;

    @ApiModelProperty(value = "租户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long tenantId;

    @ApiModelProperty(value = "备注")
    private String remark;

    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    private LocalDateTime createTime ;

    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;

    private LocalDateTime modifyTime;

    @ApiModelProperty(value = "逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;

    @ApiModelProperty(value = "版本")
    private Integer auditDataVersion;
    /**
     * 操作人姓名
     */
    @ApiModelProperty("操作人姓名")
    private String operUserName;
}
