package com.elitescloud.cloudt.support.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author Chris
 * @date 2021-03-10
 */
@Data
public class OrgAddrQualifyRpcDTO implements Serializable {

    private static final long serialVersionUID = -5583300960423680138L;

    /**
     * ID
     */
    @ApiModelProperty("ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 证照编号(文件自己的编号)
     */
    @ApiModelProperty("证照编号(文件自己的编号)")
    private String qualifyNo;

    /**
     * 资质类型:[UDC]ORG:ADDR_QUALIFY_TYPE
     */
    @ApiModelProperty("资质类型:[UDC]ORG:ADDR_QUALIFY_TYPE")
    @SysCode(sys = "ORG", mod = "ADDR_QUALIFY_TYPE")
    private String qualifyType;
    @ApiModelProperty(value = "资质类型名称")
    private String qualifyTypeName;

    /**
     * 资质证照状态:[UDC]COM:STATUS_ACTIVEORNO
     */
    @ApiModelProperty("资质证照状态:[UDC]COM:STATUS_ACTIVEORNO")
    @SysCode(sys = "COM", mod = "STATUS_ACTIVEORNO")
    private String qualifyStatus;
    @ApiModelProperty(value = "资质证照状态名称")
    private String qualifyStatusName;

    /**
     * 生效日期
     */
    @ApiModelProperty("生效日期")
    private LocalDateTime validFrom;

    /**
     * 失效日期
     */
    @ApiModelProperty("失效日期")
    private LocalDateTime validTo;

    /**
     * 资质文件ID
     */
    @ApiModelProperty("资质文件ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long qualifyFileId;

    /**
     * 资质文件名称
     */
    @ApiModelProperty("资质文件名称")
    private String qualifyFileName;

    /**
     * 资质文件编号(上传后系统生成的编号)
     */
    @ApiModelProperty("资质文件编号(上传后系统生成的编号)")
    private String qualifyFileCode;

    /**
     * 数据来源
     */
    @ApiModelProperty("数据来源")
    private String dataSource;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * ES1
     */
    @ApiModelProperty("ES1")
    private String es1;

    /**
     * ES2
     */
    @ApiModelProperty("ES2")
    private String es2;

    /**
     * ES3
     */
    @ApiModelProperty("ES3")
    private String es3;

    /**
     * ES4
     */
    @ApiModelProperty("ES4")
    private String es4;

    /**
     * ES5
     */
    @ApiModelProperty("ES5")
    private String es5;

    /**
     * ES6
     */
    @ApiModelProperty("ES6")
    private String es6;

    /**
     * ES7
     */
    @ApiModelProperty("ES7")
    private String es7;

    /**
     * ES8
     */
    @ApiModelProperty("ES8")
    private String es8;

    /**
     * ES9
     */
    @ApiModelProperty("ES9")
    private String es9;

    /**
     * ES10
     */
    @ApiModelProperty("ES10")
    private String es10;
}
