package com.elitescloud.cloudt.support.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @author Chris
 * @date 2021-05-25
 */
@Data
@ApiModel("组织RPC DTO")
public class OrgBuRpcDTO implements Serializable {

    /**
     * BU ID
     */
    @ApiModelProperty("BU ID")
    private Long id;

    /**
     * BU编号
     */
    @ApiModelProperty("BU编号")
    private String buCode;

    /**
     * BU名称
     */
    @ApiModelProperty("BU名称")
    private String buName;

    /**
     * BU简称
     */
    @ApiModelProperty("BU简称")
    private String buAbbr;

    /**
     * BU类型[UDC]ORG:BU_TYPE
     */
    @ApiModelProperty("BU类型[UDC]ORG:BU_TYPE")
    private String buType;
    @ApiModelProperty("BU类型名称")
    private String buTypeName;

    /**
     * 店铺类型[UDC]ORG:BU_TYPE2
     */
    @ApiModelProperty("店铺类型[UDC]ORG:BU_TYPE2")
    private String buType2;

    /**
     * BU状态 [UDC]COM:STATUS_BU
     */
    @ApiModelProperty("BU状态 [UDC]COM:STATUS_BU")
    private String buStatus;

    /**
     * 所属公司ID
     */
    @ApiModelProperty("所属公司ID")
    private Long ouId;

    /**
     * 所属公司编号
     */
    @ApiModelProperty("所属公司编号")
    private String ouCode;

    /**
     * 所属公司名称
     */
    @ApiModelProperty("所属公司名称")
    private String ouName;

    /**
     * 地址号
     */
    @ApiModelProperty("地址号")
    private Long addrNo;

    /**
     * 成本中心编码
     */
    @ApiModelProperty("成本中心编码")
    private String costCentreCode;

    /**
     * 成本中心名称
     */
    @ApiModelProperty("成本中心名称")
    private String costCentreName;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private LocalDateTime createTime;
}
