package com.elitescloud.cloudt.support.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/3/15
 */
@Data
@ApiModel("组织树列表参数")
public class OrgBuTreeRemotePagingParam implements Serializable {

    private static final long serialVersionUID = -3325554634718840053L;

    /**
     * 组织树类型
     */
    @ApiModelProperty("组织树类型")
    private String buTreeType;

    /**
     * 组织树状态
     */
    @ApiModelProperty("组织树状态")
    private String buTreeStatus;

    /**
     * 组织树编号
     */
    @ApiModelProperty("组织树编号")
    private String buTreeCode;

    /**
     * 组织树名称
     */
    @ApiModelProperty("组织树名称")
    private String buTreeName;

    /**
     * 页码,默认为1"
     */
    @ApiModelProperty(value = "页码,默认为1", example = "0")
    private Integer current = 0;

    /**
     * 页大小,默认为10"
     */
    @ApiModelProperty(value = "页大小,默认为10", example = "10")
    private Integer size = 10;
}
