package com.elitescloud.cloudt.support.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author Chris
 * @date 2021-04-28
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("员工DTO查询参数")
public class OrgEmpRpcDtoParam implements Serializable {

    private static final long serialVersionUID = -6574002636324325742L;

    /**
     * 员工ID列表
     */
    @ApiModelProperty("员工ID列表")
    private List<Long> empIds;

    /**
     * 员工编号列表
     */
    @ApiModelProperty("员工编号列表")
    private List<String> empCodes;

    /**
     * 员工绑定的用户id列表
     */
    @ApiModelProperty("员工绑定的用户id列表")
    private List<Long> userIds;

    /**
     * 员工类型 [UDC]ORG:EMP_TYPE
     */
    @ApiModelProperty("员工类型 [UDC]ORG:EMP_TYPE")
    private String empType;

    @ApiModelProperty("是否需要全部数据,0/默认：所有数据（除已逻辑删除的数据）；1:正常状态数据；2：已停用状态数据")
    private Integer allDataFlag;
}
