package com.elitescloud.cloudt.support.service;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.support.dto.OrgEmpRpcDTO;
import com.elitescloud.cloudt.support.dto.OrgUserEmpInfoRpcDTO;
import com.elitescloud.cloudt.support.param.OrgEmpRpcDtoParam;
import com.elitescloud.cloudt.support.param.OrgEmpUserRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author Chris
 * @date 2021-04-28
 */
@FeignClient(name = Application.NAME, path = OrgEmpRpcService.URI)
public interface OrgEmpRpcService {
    String URI = Application.URI_PREFIX + "/orgEmpRpcService";

    /**
     * 获取员工信息列表，该接口一般应用与如下场景
     * 1. 第三方通过id或者code获取一些基本信息，用于后端处理
     * 2. 检查数据是否存在，存在则会返回数据，不存在则不会返回数据
     * <p>
     * 如果传入的查询参数均为空，则不返回任何数据，防止获取全部数据
     * <p>
     * 注意接口返回数据没有上限控制，请合理使用，保证效能
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 查询条件，每个条件使用 and 关联
     * @return dto
     */
    @GetMapping(value = "/findEmpDtoByParam")
    List<OrgEmpRpcDTO> findEmpDtoByParam(@RequestParam("param") OrgEmpRpcDtoParam param);

    /**
     * 根据用户ID获取当前用户员工信息
     * 包含员工所属组织，所属公司，以及默认联系方式
     * <p>
     * 如果返回的结果是 null，则说明当前用户并未绑定员工
     * <p>
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param userId 用户ID
     * @return 员工相关信息
     */
    @GetMapping(value = "/findUserEmpInfo")
    OrgUserEmpInfoRpcDTO findUserEmpInfo(@RequestParam("userId") Long userId);

    /**
     * 用户导入 绑定员工接口
     * <p>
     * 返回信息：当前员工已经被其他用户绑定
     * <p>
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param 保存参数
     * @return 错误信息
     */
    @PostMapping(value = "/userExportBindEmp")
    String userExportBindEmp(@RequestParam("param") List<OrgEmpUserRpcParam> param);
}
