package com.elitescloud.cloudt.support.vo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/3/15
 */
@Data
@ApiModel(description = "组织树单条记录详细参数")
public class OrgBuTreeRemoteDetailVO implements Serializable {

    private static final long serialVersionUID = 7559981506900401417L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("组织树id")
    private Long id;

    /**
     * 组织树类型
     */
    @ApiModelProperty("组织树类型")
    private String buTreeType;

    /**
     * 组织树状态
     */
    @ApiModelProperty("组织树状态")
    @SysCode(sys = "ORG", mod = "BUTREE_STATUS")
    private String buTreeStatus;
    private String buTreeStatusName;

    /**
     * 组织树编号
     */
    @ApiModelProperty("组织树编号")
    private String buTreeCode;

    /**
     * 组织树名称
     */
    @ApiModelProperty("组织树名称")
    private String buTreeName;

    /**
     * 组织树版本
     */
    @ApiModelProperty("组织树版本")
    private String buTreeVersion;

    /**
     * 组织树当前版本
     */
    @ApiModelProperty("组织树当前版本")
    private String nowVersion;

    /**
     * 组织树明细树形结构
     */
    @ApiModelProperty("组织树明细树形结构")
    private List<OrgBuTreeDRemoteVO> orgBuTreeDVOList;
}
