package com.elitescloud.cloudt.support.vo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/3/15
 */
@Data
@ApiModel(description = "组织树分页反参")
public class OrgBuTreeRemotePagingVO implements Serializable {

    private static final long serialVersionUID = -6495692859852324754L;

    /**
     * ID
     */
    @ApiModelProperty("ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 组织树类型
     */
    @ApiModelProperty("组织树类型")
    @SysCode(sys = "ORG", mod = "BUTREE_TYPE")
    private String buTreeType;
    private String buTreeTypeName;

    /**
     * 组织树编号
     */
    @ApiModelProperty("组织树编号")
    private String buTreeCode;

    /**
     * 组织树名称
     */
    @ApiModelProperty("组织树名称")
    private String buTreeName;

    /**
     * 组织树状态
     */
    @ApiModelProperty("组织树状态")
    @SysCode(sys = "ORG", mod = "BUTREE_STATUS")
    private String buTreeStatus;
    private String buTreeStatusName;

    /**
     * 组织树当前版本
     */
    @ApiModelProperty("组织树当前版本")
    private String nowVersion;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    /**
     * 记录创建者
     */
    @ApiModelProperty("记录创建者")
    private String creator;
}
