package com.elitescloud.cloudt.system.constant;

import com.elitescloud.cloudt.common.common.BaseUdc;

/**
 * 员工类型.
 *
 * @author Kaiser（wang shao）
 * @date 2022/10/29
 */
public class EmployeeType extends BaseUdc<EmployeeType> {
    private static final long serialVersionUID = 968875289740903243L;

    public static final EmployeeType FORMAL = new EmployeeType("FORMAL", "正式");
    public static final EmployeeType TEMP = new EmployeeType("TEMP", "临时");
    public static final EmployeeType INTERNSHIP = new EmployeeType("INTERNSHIP", "实习");
    public static final EmployeeType TRIAL = new EmployeeType("TRIAL", "试用");

    @Override
    public String getUdcCode() {
        return "employeeType";
    }

    public EmployeeType() {
    }

    public EmployeeType(String value) {
        super(value);
    }

    public EmployeeType(String value, String description) {
        super(value, description);
    }
}
