package com.elitescloud.cloudt.system.constant;

import com.elitescloud.cloudt.common.base.common.SafeEnum;

/**
 * 用户的账号来源类型.
 * <p>
 * 账号来源类型{@link com.elitescloud.cloudt.system.entity.SysUserDO.sourceType}
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/17
 */
public final class UserSourceType extends SafeEnum<UserSourceType> {
    private static final long serialVersionUID = 707543390723559694L;

    /**
     * 初始化的用户
     */
    public static final UserSourceType INIT = new UserSourceType("init", "系统初始化");
    /**
     * 系统自动创建的用户
     */
    public static final UserSourceType SYS = new UserSourceType("sys", "系统创建");
    /**
     * 由用户创建的用户
     */
    public static final UserSourceType CREATE = new UserSourceType("crt", "用户创建");
    /**
     * 用户自己注册的用户
     */
    public static final UserSourceType REGISTER = new UserSourceType("reg", "用户注册");
    /**
     * 通过微信自动注册
     */
    public static final UserSourceType WECHAT = new UserSourceType("wec", "微信注册");
    /**
     * 其它
     */
    public static final UserSourceType OTHER = new UserSourceType("oth", "其它");

    public UserSourceType() {
    }

    public UserSourceType(String name) {
        super(name);
    }

    public UserSourceType(String name, String description) {
        super(name, description);
    }

    public static UserSourceType parse(String name) {
        return SafeEnum.valueOf(UserSourceType.class, name);
    }
}
