package com.elitescloud.cloudt.system.dto;

import com.elitescloud.cloudt.system.constant.TenantType;
import com.elitescloud.cloudt.common.constant.TenantIsolateStrategy;
import lombok.Data;

import java.io.Serializable;
import java.util.Set;

/**
 * 租户基本信息.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/23
 */
@Data
public class SysTenantDTO implements Serializable {
    private static final long serialVersionUID = -9133437108576656370L;

    /**
     * 记录唯一ID
     */
    private Long id;
    /**
     * 租户编号
     */
    private String tenantCode;
    /**
     * 租户名称
     */
    private String tenantName;
    /**
     * 租户管理员ID
     */
    private Long sysUserId;

    /**
     * 租户类型
     */
    private TenantType type;

    /**
     * 租户数据隔离策略，目前仅支持SCHEMA
     */
    private TenantIsolateStrategy isolationStrategy;

    /**
     * 租户数据库是否已初始化
     */
    private Boolean dbInitialized;

    /**
     * 域名地址
     */
    private String tenantDomain;
    /**
     * 租户自己的域名地址
     */
    private String customDomain;

    /**
     * 租户数据隔离数据源
     */
    private Long databaseSourceId;

    /**
     * schema名称，支持英文字母、数字和下划线
     */
    private String schemaName;

    /**
     * 所属行业，[UDC]COM:INDUSTRY
     */
    private String industry;

    /**
     * 所属客户，[UDC]SYS:CUSTOMER
     */
    private String customer;

    /**
     * 分配的应用
     */
    private Set<String> appCodes;
}
