package com.elitescloud.cloudt.system.dto;

import lombok.Data;
import org.springframework.util.StringUtils;

import java.io.Serializable;

/**
 * 用户基本信息.
 *
 * @author Kaiser（wang shao）
 * @date 2022/9/30
 */
@Data
public class SysUserBasicDTO implements Serializable {
    private static final long serialVersionUID = 6082027267800639867L;

    /**
     * 用户ID
     */
    private Long id;

    /**
     * 登录账号
     */
    private String username;

    /**
     * 姓名-姓氏
     */
    private String lastName;

    /**
     * 姓名-名字
     */
    private String firstName;

    /**
     * 性别
     * {@link com.elitescloud.cloudt.common.constant.Gender}
     */
    private String gender;

    /**
     * 昵称
     */
    private String nickName;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 身份证号
     */
    private String idCard;

    /**
     * 用户头像地址，可直接访问
     */
    private String avatarUrl;

    /**
     * 用户头像在文件服务器中的标识
     */
    private String avatarCode;

    /**
     * 获取全名
     *
     * @return 全名
     */
    public String getFullName() {
        if (!StringUtils.hasText(lastName)) {
            return firstName;
        }

        return lastName + (firstName == null ? "" : firstName);
    }
}
