package com.elitescloud.cloudt.system.dto.req;

import com.elitescloud.cloudt.system.constant.UserType;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Set;

/**
 * 用户创建.
 *
 * @author Kaiser（wang shao）
 * @date 2022/10/27
 */
@Data
public class SysUserUpdateDTO implements Serializable {
    private static final long serialVersionUID = -1507601283916820339L;

    /**
     * 用户ID
     */
    private Long id;

    /**
     * 登录账号
     */
    private String username;

    /**
     * 登录密码
     */
    private String password;

    /**
     * 姓名
     */
    private String fullName;

    /**
     * 性别
     * {@link com.elitescloud.cloudt.common.constant.Gender}
     */
    private String gender;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 电话
     */
    private String phone;

    /**
     * 个人邮箱
     */
    private String email;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 账号过期时间
     */
    private LocalDateTime expiredTime;

    /**
     * 身份证号
     */
    private String idCard;

    /**
     * 地址
     */
    private String address;

    /**
     * 备注
     */
    private String remark;

    /**
     * 终端
     */
    private Set<String> terminalsAdd;

    /**
     * 新增的用户类型
     * {@link UserType}
     */
    private Set<String> typesAdd;

    /**
     * 扩展参数
     */
    private Object extend;
}
